var tplMgr = {
	fCbkPath : "des:.cbkClosed",
	fCbkInit : true,

	fStrings : ["Retour à la page en cours du contenu","",
	/*02*/      "Cacher le contenu de \'%s\'","Afficher le contenu de \'%s\'",
	/*04*/      "",""],

	init : function() {
		try{
			this.fStore = new this.LocalStore();
			var vHash = window.location.hash;
			if (vHash.length>0); vHash = vHash.substring(1);
			
			//Section outline
			this.fSecOutCo = scPaLib.findNode("ide:content/des:div.secOutFra/chi:div.secOutUi/chi:ol");
			if(this.fSecOutCo){
				this.fSecOutBtn = scPaLib.findNode("ide:content/des:div.secOutFra/chi:div.secOutTi/chi:a");
				if(this.fStore.get("secOutCollapse")=="true") this.secOutToggle();
			}

			// Callback functions
			if ("scDynUiMgr" in window) {
				scDynUiMgr.collBlk.addOpenListener(this.sCollBlkOpen);
				scDynUiMgr.collBlk.addCloseListener(this.sCollBlkClose);
			}
			if ("scTooltipMgr" in window ) {
				scTooltipMgr.addShowListener(this.sTtShow);
				scTooltipMgr.addHideListener(this.sTtHide);
			}
			
			// Close collapsable blocks that are closed by default.
			if (this.fCbkInit){
				var vCbks = scPaLib.findNodes(this.fCbkPath);
				for (var i=0; i<vCbks.length; i++) {
					if (!vHash || vHash && vHash != scPaLib.findNode("chi:", vCbks[i]).id) {
						var vTgl = scPaLib.findNode("des:a", vCbks[i]);
						if (vTgl) vTgl.onclick();
					}
				}
			}

			scOnLoads[scOnLoads.length] = this;
		}catch(e){scCoLib.log("ERROR - tplMgr.init : "+e)}
	},
	
	onLoad : function() {
		// Page type init
		var vPageType = sc$("page").getAttribute("data-type");
		this.fIsGuidePage = vPageType == "guide";
		this.fIsToolsPage = vPageType == "tools";
		this.fIsSubPage = vPageType == "sub";
		if (this.fIsGuidePage) this.fStore.set("guideUrl", document.location.href);
		else {
			var vRetBtn = scPaLib.findNode("ide:menu/des:a");
			var vRetUrl = this.fStore.get("guideUrl");
			if (vRetBtn && vRetUrl){
				vRetBtn.setAttribute("href", vRetUrl);
				vRetBtn.title = this.fStrings[0];
			}
			// Map outline
			var vMnuItems = scPaLib.findNodes("ide:content/des:ul.sw_outMap_navList/des:a.mnuSel_no");
			if (vRetUrl && vMnuItems){
				var vPage = vRetUrl.substring(vRetUrl.lastIndexOf("/")+1);
				var vFound=false;
				for(var i = 0; i < vMnuItems.length; i++) {
					var vMnuItem = vMnuItems[i];
					if(vMnuItem.href.substring(vMnuItem.href.lastIndexOf("/")+1) == vPage){
						vMnuItem.className = vMnuItem.className.replace("mnuSel_no","mnuSel_yes");
						vFound=true;
						break;
					}
				}
				if (!vFound) vMnuItems[0].className = vMnuItems[0].className.replace("mnuSel_no","mnuSel_yes");
			}
		}
	},

	makeVisible : function(pNode){
		// Ouvre bloc collapsable contenant pNode
		var vCollBlk = scPaLib.findNode("anc:.collBlk_closed",pNode);
		if(vCollBlk) vCollBlk.fTitle.onclick();
	},

	setExpandAll : function(pExpand){
		if ("dokielMgr" in window){
			if (pExpand) dokielMgr.cancelStepMode();
			dokielMgr.setInteractiveScreenMode(!pExpand);
		}
		if("scSiLib" in window) scSiLib.fireResizedNode(sc$("main"));
	},

	secOutToggle : function() {
		if (!this.fSecOutCo || !this.fSecOutBtn) return false;
		scDynUiMgr.collBlkToggle(this.fSecOutBtn,this.fSecOutCo,"secOut_op","secOut_cl");
		this.fStore.set("secOutCollapse", this.fSecOutCo.style.display == "none");
		return false;
	},

/* === Callback functions =================================================== */
	/** Tooltip lib show callback */
	sTtShow: function(pNode) {
		var vClsBtn = scPaLib.findNode("des:a.tooltip_x", scTooltipMgr.fCurrTt);
		if (vClsBtn) window.setTimeout(function(){vClsBtn.focus();}, pNode.fOpt.DELAY + 10);
	},
	/** Tooltip lib hide callback : this = scTooltipMgr */
	sTtHide: function(pNode) {
		if (pNode) pNode.focus();
	},
	/** Collapable block Callback functions. */
	sCollBlkOpen: function(pCo, pTitle) {
		if (pTitle) pTitle.title = tplMgr.fStrings[2].replace("%s", (pTitle.innerText ? pTitle.innerText: pTitle.textContent));
	},
	sCollBlkClose: function(pCo, pTitle) {
		if (pTitle) pTitle.title = tplMgr.fStrings[3].replace("%s", (pTitle.innerText ? pTitle.innerText: pTitle.textContent));
	},

	/** Local Storage API (localStorage/userData/cookie) */
	LocalStore : function (pId){
		if (pId && !/^[a-z][a-z0-9]+$/.exec(pId)) throw new Error("Invalid store name");
		this.fId = pId || "";
		this.fRootKey = document.location.pathname.substring(0,document.location.pathname.lastIndexOf("/")) +"/";
		if (typeof localStorage != "undefined") {
			this.get = function(pKey) {var vRet = localStorage.getItem(this.fRootKey+this.xKey(pKey));return (typeof vRet == "string" ? unescape(vRet) : null)};
			this.set = function(pKey, pVal) {localStorage.setItem(this.fRootKey+this.xKey(pKey), escape(pVal))};
		} else if (window.ActiveXObject){
			this.get = function(pKey) {this.xLoad();return this.fIE.getAttribute(this.xEsc(pKey))};
			this.set = function(pKey, pVal) {this.fIE.setAttribute(this.xEsc(pKey), pVal);this.xSave()};
			this.xLoad = function() {this.fIE.load(this.fRootKey+this.fId)};
			this.xSave = function() {this.fIE.save(this.fRootKey+this.fId)};
			this.fIE=document.createElement('div');
			this.fIE.style.display='none';
			this.fIE.addBehavior('#default#userData');
			document.body.appendChild(this.fIE);
		} else {
			this.get = function(pKey){var vReg=new RegExp(this.xKey(pKey)+"=([^;]*)");var vArr=vReg.exec(document.cookie);if(vArr && vArr.length==2) return(unescape(vArr[1]));else return null};
			this.set = function(pKey,pVal){document.cookie = this.xKey(pKey)+"="+escape(pVal)};
		}
		this.xKey = function(pKey){return this.fId + this.xEsc(pKey)};
		this.xEsc = function(pStr){return "LS" + pStr.replace(/ /g, "_")};
	}
}