/* Optim Office page manager */
var tplMgr = {
	fCbkInit : true,
	fCookieWarn : false,
	fCbkClosedPath : "des:.cbkClosed",
	fCbkOpenPath : "des:.cbkOpen",
	fEwebPath : "des:.binWeb/chi:iframe",
	fEwebMaxHeight : 1200,
	fBkBtnPath : "des:.outBkBtn/des:a",
	fListeners : {showSearch:[],resetSearch:[]},

	fStrings : ["Cacher le contenu de \'%s\'","Afficher le contenu de \'%s\'",
	/*02*/      "En poursuivant votre navigation sans modifier vos paramètres de cookies, vous acceptez l\'utilisation des cookies.","Pour en savoir plus, %s.",
	/*04*/      "cliquez ici","Fermer"],

	init : function(){
		try{
			var vHash = window.location.hash;
			if (vHash.length>0); vHash = vHash.substring(1);
			
			// Set callback functions.
			scDynUiMgr.collBlk.addOpenListener(this.sCollBlkOpen);
			scDynUiMgr.collBlk.addCloseListener(this.sCollBlkClose);
			if ("scTooltipMgr" in window ) {
				scTooltipMgr.addShowListener(this.sTtShow);
				scTooltipMgr.addHideListener(this.sTtHide);
			}
	
			// Close collapsable blocks that are closed by default.
			if (this.fCbkInit){
				var vCbks = scPaLib.findNodes(this.fCbkClosedPath);
				for (var i=0; i<vCbks.length; i++) {
					if (!vHash || vHash && vHash != scPaLib.findNode("chi:", vCbks[i]).id) {
						var vTgl = scPaLib.findNode("des:a", vCbks[i]);
						if (vTgl) vTgl.onclick();
					}
				}
				vCbks = scPaLib.findNodes(this.fCbkOpenPath);
				for (var i=0; i<vCbks.length; i++) {
					var vTgl = scPaLib.findNode("des:a", vCbks[i]);
					if (vTgl) vTgl.title = tplMgr.fStrings[0].replace("%s", (vTgl.innerText ? vTgl.innerText: vTgl.textContent));
				}
			}

			// Init Ewebs
			var vEwebs = scPaLib.findNodes(this.fEwebPath);
			for (var i=0; i<vEwebs.length; i++) {
				var vEweb = vEwebs[i];
				vEweb.fParent = vEweb.parentNode;
				vEweb.fParent.style.position = "relative";
				vEweb.fParent.style.height = "200px";
				vEweb.style.position = "absolute";
				vEweb.style.width = "100%";
				vEweb.style.height = "100%";
				if(scCoLib.isIE) vEweb.onreadystatechange = this.sOnloadEweb;
				else vEweb.onload = this.sOnloadEweb;
			}

			this.fCurrentUrl = scCoLib.hrefBase();
			this.fPageCurrent = scServices.scLoad.getUrlFromRoot(this.fCurrentUrl);
			this.fStore = new this.LocalStore();
			
			if (this.fCookieWarn && this.fStore.get("CookieWarn")!="done"){
				var vCookieWarnBar = scDynUiMgr.addElement("div", scPaLib.findNode("bod:"), "cookieWarnBar", scPaLib.findNode("bod:/chi:"));
				var vMsgBox = scDynUiMgr.addElement("span", vCookieWarnBar, "cookieWarnMsg")
				var vMsg = this.fStrings[2];
				var vLegalLink = scPaLib.findNode("ide:footer/des:a.privacyLnk");
				if (vLegalLink) vMsg += " " + this.fStrings[3].replace("%s", '<a href="'+vLegalLink.href+'">'+this.fStrings[4]+'</a>');
				vMsgBox.innerHTML = vMsg + " ";
				var vCookieWarnBtn = scDynUiMgr.addElement("a", vCookieWarnBar, "cookieWarnBtn");
				vCookieWarnBtn.setAttribute("role", "button");
				vCookieWarnBtn.setAttribute("title", this.fStrings[5]);
				vCookieWarnBtn.href = "#";
				vCookieWarnBtn.innerHTML = '<span>'+this.fStrings[5]+'</span>';
				vCookieWarnBtn.fBar = vCookieWarnBar;
				vCookieWarnBtn.onclick = function(){
					this.fBar.className = this.fBar.className + " acknowledged";
				}
				this.fStore.set("CookieWarn", "done");
			}
		}catch(e){scCoLib.log("ERROR - tplMgr.init : "+e)}
	},
	setCookieWarn : function(pFlag) {
		this.fCookieWarn = pFlag;
	},
	saveLocation : function() {
		this.fStore.set("lastPageUrl", document.location.href);
	},
	loadPage : function(pUrl){
		if (pUrl && pUrl.length>0) {
			window.location.href = scServices.scLoad.getPathFromRoot(pUrl);
		}
	},
	scrollTo : function(pId){
		this.loadPage(this.fPageCurrent +"#" + pId);
	},
	setBackButtons : function() {
		var vBkBtns = scPaLib.findNodes(this.fBkBtnPath);
		for (var i=0; i<vBkBtns.length; i++) vBkBtns[i].onclick=function(){var vUrl = tplMgr.fStore.get("lastPageUrl");if(vUrl) this.setAttribute("href", vUrl)};
	},
	xMediaFallback: function(pMedia) {
		while (pMedia.firstChild) {
			if (pMedia.firstChild instanceof HTMLSourceElement) {
				pMedia.removeChild(pMedia.firstChild);
			} else {
				pMedia.parentNode.insertBefore(pMedia.firstChild, pMedia);
			}
		}
		pMedia.parentNode.removeChild(pMedia);
	},
	
	/* === Utilities ============================================================ */
	/** tplMgr.xAddBtn : Add a HTML button to a parent node. */
	xAddBtn : function(pParent, pClassName, pCapt, pTitle, pNxtSib) {
		var vBtn = pParent.ownerDocument.createElement("a");
		vBtn.className = pClassName;
		vBtn.fName = pClassName;
		vBtn.href = "#";
		vBtn.target = "_self";
		if (pTitle) vBtn.setAttribute("title", pTitle);
		if (pCapt) vBtn.innerHTML = '<span class="capt">' + pCapt + '</span>';
		if (pNxtSib) pParent.insertBefore(vBtn,pNxtSib);
		else pParent.appendChild(vBtn);
		return vBtn;
	},
	/** tplMgr.xAddElt : Add an HTML element to a parent node. */
	xAddElt : function(pName, pParent, pClassName, pNoDisplay, pHidden, pNxtSib){
		var vElt;
		if(scCoLib.isIE && pName.toLowerCase() == "iframe") {
			//BUG IE : impossible de masquer les bordures si on ajoute l'iframe via l'API DOM.
			var vFrmHolder = pParent.ownerDocument.createElement("div");
			if (pNxtSib) pParent.insertBefore(vFrmHolder,pNxtSib);
			else pParent.appendChild(vFrmHolder);
			vFrmHolder.innerHTML = "<iframe scrolling='no' frameborder='0'></iframe>";
			vElt = vFrmHolder.firstChild;
		} else {
			vElt = pParent.ownerDocument.createElement(pName);
			if (pNxtSib) pParent.insertBefore(vElt,pNxtSib);
			else pParent.appendChild(vElt);
		}
		if (pClassName) vElt.className = pClassName;
		if (pNoDisplay) vElt.style.display = "none";
		if (pHidden) vElt.style.visibility = "hidden";
		return vElt;
	},
	/** tplMgr.xSwitchClass - replace a class name. */
	xSwitchClass : function(pNode, pClassOld, pClassNew, pAddIfAbsent, pMatchExact) {
		var vAddIfAbsent = typeof pAddIfAbsent == "undefined" ? false : pAddIfAbsent;
		var vMatchExact = typeof pMatchExact == "undefined" ? true : pMatchExact;
		var vClassName = pNode.className;
		var vReg = new RegExp("\\b"+pClassNew+"\\b");
		if (vMatchExact && vClassName.match(vReg)) return;
		var vClassFound = false;
		if (pClassOld && pClassOld != "") {
			if (vClassName.indexOf(pClassOld)==-1){
				if (!vAddIfAbsent) return;
				else if (pClassNew && pClassNew != '') pNode.className = vClassName + " " + pClassNew;
			} else {
				var vCurrentClasses = vClassName.split(' ');
				var vNewClasses = new Array();
				for (var i = 0, n = vCurrentClasses.length; i < n; i++) {
					var vCurrentClass = vCurrentClasses[i];
					if (vMatchExact && vCurrentClass != pClassOld || !vMatchExact && vCurrentClass.indexOf(pClassOld) != 0) {
						vNewClasses.push(vCurrentClasses[i]);
					} else {
						if (pClassNew && pClassNew != '') vNewClasses.push(pClassNew);
						vClassFound = true;
					}
				}
				pNode.className = vNewClasses.join(' ');
			}
		}
		return vClassFound;
	},
	/** Tooltip lib show callback */
	sTtShow: function(pNode) {
		var vClsBtn = scPaLib.findNode("des:a.tt_x", scTooltipMgr.fCurrTt);
		if (vClsBtn) window.setTimeout(function(){vClsBtn.focus();}, pNode.fOpt.DELAY + 10);
	},
	/** Tooltip lib hide callback : this = scTooltipMgr */
	sTtHide: function(pNode) {
		if (pNode) pNode.focus();
	},
	/** Collapsable on open callback function. */
	sCollBlkOpen: function(pCo, pTitle) {
		if (pTitle) pTitle.title = tplMgr.fStrings[0].replace("%s", (pTitle.innerText ? pTitle.innerText: pTitle.textContent));
	},
	/** Collapsable on close callback function. */
	sCollBlkClose: function(pCo, pTitle) {
		if (pTitle) pTitle.title = tplMgr.fStrings[1].replace("%s", (pTitle.innerText ? pTitle.innerText: pTitle.textContent));
	},
	/** Eweb on load callback function. */
	sOnloadEweb: function() {
		try{
			if(scCoLib.isIE && this.readyState != "complete") return;
			try{var vDoc = this.contentWindow.document}catch(e){};
			this.fParent.style.height = Math.min((vDoc ? vDoc.body.scrollHeight+2 : 500), tplMgr.fEwebMaxHeight)+"px";
		} catch(e){scCoLib.log("ERROR tplMgr.sOnloadEweb", e);}
	},
	/** Local Storage API (localStorage/userData/cookie) */
	LocalStore : function (pId){
		if (pId && !/^[a-z][a-z0-9]+$/.exec(pId)) throw new Error("Invalid store name");
		this.fId = pId || "";
		this.fRootKey = scServices.scLoad.getRootUrl();
		if ("localStorage" in window) {
			this.get = function(pKey) {var vRet = localStorage.getItem(this.fRootKey+this.xKey(pKey));return (typeof vRet == "string" ? unescape(vRet) : null)};
			this.set = function(pKey, pVal) {localStorage.setItem(this.fRootKey+this.xKey(pKey), escape(pVal))};
		} else if (window.ActiveXObject){
			this.get = function(pKey) {this.xLoad();return this.fIE.getAttribute(this.xEsc(pKey))};
			this.set = function(pKey, pVal) {this.fIE.setAttribute(this.xEsc(pKey), pVal);this.xSave()};
			this.xLoad = function() {this.fIE.load(this.fRootKey+this.fId)};
			this.xSave = function() {this.fIE.save(this.fRootKey+this.fId)};
			this.fIE=document.createElement('div');
			this.fIE.style.display='none';
			this.fIE.addBehavior('#default#userData');
			document.body.appendChild(this.fIE);
		} else {
			this.get = function(pKey){var vReg=new RegExp(this.xKey(pKey)+"=([^;]*)");var vArr=vReg.exec(document.cookie);if(vArr && vArr.length==2) return(unescape(vArr[1]));else return null};
			this.set = function(pKey,pVal){document.cookie = this.xKey(pKey)+"="+escape(pVal)};
		}
		this.xKey = function(pKey){return this.fId + this.xEsc(pKey)};
		this.xEsc = function(pStr){return "LS" + pStr.replace(/ /g, "_")};
	}
}

